﻿<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Kalend" %>
<%@ import Namespace="Soneta.Tools" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Lista obecności</title>
		<script runat="server">
		    
	public class PrnParams: ContextBase {
	
		public PrnParams(Context context): base(context) {
			if (context.Contains(typeof(ActualDate)))
				data = ((ActualDate)context[typeof(ActualDate)]).Actual;
			else
				data = Date.Today;
		}
		
		Date data;
		[Required]
		[Priority(10)]
		[Caption("Lista obecności z dnia")]
		public Date Data {
			get { return data; }
			set { data = value; }
		}			
	}

    public class SrParams : SerializableContextBase {
        public SrParams(Context context) : base(context) {
        }

        //static bool tylkoPracownicyZatrudnieni = true;
        bool tylkoPracownicyZatrudnieni = true;
        [Priority(10)]
        [Caption("Tylko zatrudnieni")]
        public bool TylkoPracownicyZatrudnieni {
            get { return tylkoPracownicyZatrudnieni; }
            set {
                tylkoPracownicyZatrudnieni = value;
                OnChanged(EventArgs.Empty);
            }
        }

        bool nieobecnosciWgTypuDnia = false;
        [Priority(20)]
        [Caption("Nieobecn. wg typu dnia")]
        public bool NieobecnosciWgTypuDnia {
            get { return nieobecnosciWgTypuDnia; }
            set {
                nieobecnosciWgTypuDnia = value;
                OnChanged(EventArgs.Empty);
            }
        }

        bool pelneStanowisko = false;
        [Priority(30)]
        [Caption("Stanowisko pełna nazwa")]
        public bool PelneStanowisko {
            get { return pelneStanowisko; }
            set {
                pelneStanowisko = value;
                OnChanged(EventArgs.Empty);
            }
        }        
    }		
		            
	PrnParams pars = null; 
	[Context(Required=true)] 
	public PrnParams Params { 
		get { return pars; } 
		set { pars = value; } 
	}

    SrParams srpars;
    [SettingsContext]
    public SrParams SrPars {
        get { return srpars; }
        set { srpars = value; }
    }		
		            
	Date data;
	void OnContextLoad(Object sender, EventArgs args) {
		data = pars.Data;
		ReportHeader1["DATA"] = data.ToString();
	}

    void Grid1_BeforeRow(Object sender, RowEventArgs args) {
        PracHistoria ph = (PracHistoria)args.Row;
        try {
            if (srpars.TylkoPracownicyZatrudnieni && !ph.Etat.EfektywnyOkres.Contains(data))
                args.VisibleRow = false;
            else {
                KalkulatorPracownika kalk = new KalkulatorPracownika(ph.Pracownik);
                Dzien dznPlan = kalk.KalkPlanu[data];
                planOd.EditValue = dznPlan.OdGodziny;
                planCzas.EditValue = dznPlan.Czas;
                colStanowisko.EditValue = GetStanowisko(ph);

                Dzien dzn = kalk.KalkPracy[data];
                IList lst = (IList)kalk.Nieobecnosci(FromTo.Day(data), true);
                if (lst.Count != 0) {
                    string v = "";
                    if (dzn.Czas != Time.Zero)
                        v += dzn.Czas;
                    foreach (OkresNieobecności nie in lst)
                        if (!srpars.NieobecnosciWgTypuDnia || nie.Definicja.TypDni == TypyDni.Kalendarzowe || dznPlan.Definicja.Typ == TypDnia.Pracy)
                            if (!v.Contains(nie.Definicja.Skrot))
                                v += (v != "" ? " /" : "") + nie.Definicja.Skrot;
                    pracaCzas.EditValue = v;
                }
                else {
                    IList wewy = kalk.KalkPracy.WejściaWyjścia(data);
                    ArrayList we = new ArrayList();
                    ArrayList wy = new ArrayList();
                    foreach (WeWy w in wewy)
                        if (w.Wejście)
                            we.Add(w.Godzina);
                        else
                            wy.Add(w.Godzina);

                    if (we.Count > 0)
                        we1.EditValue = we[0];
                    if (we.Count > 1)
                        we2.EditValue = we[1];

                    if (wy.Count > 1)
                        wy1.EditValue = wy[0];
                    if (wy.Count > 0)
                        wyN.EditValue = wy[wy.Count - 1];
                    pracaCzas.EditValue = dzn.Czas;
                }
            }
        }
        catch (Soneta.Kalend.KalkulatorPracy.ZestPracyException ex) {
            throw new RowException(ex, ph.Pracownik, "Próba wykonania raportu dla pracownika rozliczanego wg zestawień czasu pracy.");
        }
    }

    string GetStanowisko(PracHistoria ph) {
        string stanowiskoPelne = "";
        if (srpars.PelneStanowisko)
            stanowiskoPelne = ph.Etat.StanowiskoPełne;
        if (stanowiskoPelne.Length == 0)
            stanowiskoPelne = ph.Etat.Stanowisko;
        return stanowiskoPelne;
    }
    
		</script>
		
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="ListaObecności" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" TypeName="Soneta.Business.Row[], Soneta.Business" oncontextload="OnContextLoad"></ea:datacontext>
			<cc1:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" runat="server" title="Lista obecności z dnia %DATA%"></cc1:ReportHeader>
			<ea:Grid id="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" RowTypeName="Soneta.Kadry.PracHistoria, Soneta.KadryPlace" LinkedRows="History">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP."  ID="lp" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="30" DataMember="Pracownik"  NoWrap="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="25" ID="colStanowisko" Caption="Stanowisko" runat="server"></ea:GridColumn>
					<ea:GridColumn Align="Right" Caption="Plan. wejście"  ID="planOd" 
                        runat="server" Format="{0:+}"></ea:GridColumn>
					<ea:GridColumn Align="Right" Caption="Plan. czas pracy"  ID="planCzas" runat="server"></ea:GridColumn>
					<ea:GridColumn Align="Right" Caption="Wejście"  ID="we1" runat="server" 
                        Format="{0:+}"></ea:GridColumn>
					<ea:GridColumn Align="Right" Caption="Wyjście"  ID="wy1" runat="server" 
                        Format="{0:+}"></ea:GridColumn>
					<ea:GridColumn Align="Right" Caption="Wejście"  ID="we2" runat="server" 
                        Format="{0:+}"></ea:GridColumn>
					<ea:GridColumn Align="Right" Caption="Ostatnie wyjście"  ID="wyN" 
                        runat="server" Format="{0:+}"></ea:GridColumn>
					<ea:GridColumn Align="Right" Width="12" Caption="Czas pracy"  ID="pracaCzas" runat="server"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<cc1:ReportFooter id="ReportFooter1" runat="server"></cc1:ReportFooter>
		</form>
	</body>
</HTML>
